/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#ifndef _AVEV3_H_
#define _AVEV3_H_

#include "avev3_machine.h"

#undef RXFIFO_RESET_DISABLE

#undef DPRAM_ACCESS_TWICE


  #define AVEV3_ENABLE_PAUSE
  #define AVEV3_ENABLE_TXCLKDOWN                

  #define _AVEV3_TXDESC_NUM         (50)        
  #define _AVEV3_RXDESC_NUM         (250)       
  #define _AVEV3_INTM_COUNT          20
  #define _AVEV3_IIRQ_RCVCNT        (_AVEV3_RXDESC_NUM)
  #define _AVEV3_TXFREE_THRESHOLD   10
  #define _AVEV3_MNTR_TIME          (HZ/2)

  #define AVEV3_SOCGLUE_RESET_ETH   (0x00000200)
  #define AVEV3_SOCGLUE_CLOCK_ETH   (0x00000600)

  #define AVEV3_ENABLE_LINKSPEED_SET

  #define AVEV3_MACSET_BYIOCTL

  #define AVEV3_ENABLE_LONGWAIT_BY_SLEEP     
  #ifdef AVEV3_ENABLE_LONGWAIT_BY_SLEEP
    #undef AVEV3_SEPARATE_WAIT_FOR_PHY_READY  
  #endif

  #define AVEV3_SELECT_BUILT_IN_PHY
#define AVEV3_PROC_FILE "avev3"
#define AVEV3_PHY_AUTODETECT
#define _AVEV3_MODE_LANC 

#define AVEV3_MAC_FILTER        
#define AVEV3_DEF_PROMISCOUS    
#undef  AVEV3_RX_MTU_CHANGE 

#define _AVEV3_NETIF_MSG        
#define _AVEV3_DEBUG        
#undef  _AVEV3_DEBUG_INTR

#undef  AVEV3_MICREL_AMDIX_ON

#define ADVERTISE_PAUSE_CAP 0x0400

#ifdef  _AVEV3_NETIF_MSG
#define DBG_PRINT(args...) printk("avev3: " args)
#else
#define DBG_PRINT(args...)
#endif

#define _AVEV3_IO_SIZE  (0x5000)    

#define _AVEV3_MDIO_MAXLOOP (100)   

#define AVEV3_IF_NAME   "eth%d"

#define _AVEV3_MAX_ETHFRAME (1518)

  #define   _AVEV3_RXRING_NUM   (1)
  #define   _AVEV3_DMATRX_INIT  {_AVEV3_TXDESC_NUM,{_AVEV3_RXDESC_NUM}}

#define _AVEV3_DESC_STOP    (0)
#define _AVEV3_DESC_START   (1)
#define _AVEV3_DESC_RX_SUSPEND  (2)
#define _AVEV3_DESC_RX_PERMIT   (3)

#define _AVEV3_LS_UP        (1)
#define _AVEV3_LS_DOWN      (2)
#define _AVEV3_LS_NOTHING   (0)

#define AVEV3_NULL_PTR          ((void*)0)


#define _BIT0       (0x00000001)
#define _BIT1       (0x00000002)
#define _BIT2       (0x00000004)
#define _BIT3       (0x00000008)
#define _BIT4       (0x00000010)
#define _BIT5       (0x00000020)
#define _BIT6       (0x00000040)
#define _BIT7       (0x00000080)
#define _BIT8       (0x00000100)
#define _BIT9       (0x00000200)
#define _BIT10      (0x00000400)
#define _BIT11      (0x00000800)
#define _BIT12      (0x00001000)
#define _BIT13      (0x00002000)
#define _BIT14      (0x00004000)
#define _BIT15      (0x00008000)
#define _BIT16      (0x00010000)
#define _BIT17      (0x00020000)
#define _BIT18      (0x00040000)
#define _BIT19      (0x00080000)
#define _BIT20      (0x00100000)
#define _BIT21      (0x00200000)
#define _BIT22      (0x00400000)
#define _BIT23      (0x00800000)
#define _BIT24      (0x01000000)
#define _BIT25      (0x02000000)
#define _BIT26      (0x04000000)
#define _BIT27      (0x08000000)
#define _BIT28      (0x10000000)
#define _BIT29      (0x20000000)
#define _BIT30      (0x40000000)
#define _BIT31      (0x80000000)

#define  _AVEV3_IDR       0x0000  
#define  _AVEV3_VR        0x0004  
#define  _AVEV3_GRR       0x0008  
#define  _AVEV3_EMCR      0x000C  
#define  _AVEV3_CLKCR     0x0018  

#define  _AVEV3_GIMR      0x0100  
#define  _AVEV3_GISR      0x0104  
#define  _AVEV3_GTICR     0x0108  

#define  _AVEV3_TXCR      0x0200  
#define  _AVEV3_RXCR      0x0204  
#define  _AVEV3_RXMAC1R   0x0208  
#define  _AVEV3_RXMAC2R   0x020C  
#define  _AVEV3_PASCR     0x0210  
#define  _AVEV3_MDIOCTR   0x0214  
#define  _AVEV3_MDIOAR    0x0218  
#define  _AVEV3_MDIOWDR   0x021C  
#define  _AVEV3_MDIOSR    0x0220  
#define  _AVEV3_MDIORDR   0x0224  
#define  _AVEV3_JSPR      0x0228  

#define  _AVEV3_DESCC     0x0300  
#define  _AVEV3_TXDC      0x0304   
#define  _AVEV3_RXDC0     0x0308   
#define  _AVEV3_RXDCP0    0x0320  
#define  _AVEV3_IIRQC     0x034C  

#define  _AVEV3_BFCR      0x0400  
#define  _AVEV3_GFCR      0x0404  
#define  _AVEV3_RXFC      0x0410  
#define  _AVEV3_RXOVFFC   0x0414  

#define  _AVEV3_DESC_SIZE 8       
#define  _AVEV3_TXDM      0x1000  
#define  _AVEV3_RXDM      0x1800  

#define  _AVEV3_TXDM_SIZE 0x0800  
#define  _AVEV3_RXDM_SIZE 0x1800  

#define  _AVEV3_TXDMAX    (_AVEV3_TXDM_SIZE/_AVEV3_DESC_SIZE)  
#define  _AVEV3_RXDMAX    (_AVEV3_RXDM_SIZE/_AVEV3_DESC_SIZE)  

#define _AVEV3_CDAVE_PERFCNFG   (0x4008)   
#define _AVEV3_CDAVE_RC0MSKCYC  (0x41C0)   

#define _AVEV3_SIGNAL   (0x4004)   
#define  _AVEV3_SIGNAL_H    _BIT1

#define _AVEV3_LINKSEL   (0x4034)   
#define  _AVEV3_LINKSEL_100M   _BIT0    


#define  _AVEV3_ZERO            (0x00000000)

#define  AVEV3_ID               "AVE3"

#define  _AVEV3_GRR_DMACRST   _BIT8
#define  _AVEV3_GRR_RXFFR     _BIT5
#define  _AVEV3_GRR_PHYRST    _BIT4
#define  _AVEV3_GRR_MDIOBRST  _BIT3
#define  _AVEV3_GRR_TXBRST    _BIT2
#define  _AVEV3_GRR_RXBRST    _BIT1
#define  _AVEV3_GRR_GRST      _BIT0


#define  _AVEV3_GI_GT2        _BIT27 
#define  _AVEV3_GI_GT1        _BIT26 
#define  _AVEV3_GI_DMAC       _BIT25
#define  _AVEV3_GI_PHY        _BIT24
#define  _AVEV3_GI_PKTBOVF    _BIT23 
#define  _AVEV3_GI_TXBOVF     _BIT22 
#define  _AVEV3_GI_TXFOVF     _BIT21 
#define  _AVEV3_GI_TX         _BIT16 
#define  _AVEV3_GI_SWFFOVF    _BIT15 
#define  _AVEV3_GI_RXERR      _BIT8  
#define  _AVEV3_GI_RXOVF      _BIT7  
#define  _AVEV3_GI_RXDROP     _BIT6  
#define  _AVEV3_GI_RXIINT     _BIT5  
#define  _AVEV3_GI_RXINT4     _BIT4  
#define  _AVEV3_GI_RXINT3     _BIT3  
#define  _AVEV3_GI_RXINT2     _BIT2  
#define  _AVEV3_GI_RXINT1     _BIT1  
#define  _AVEV3_GI_RXINT0     _BIT0  
#define  _AVEV3_GI_NORMALRX   (_BIT0)
#define  _AVEV3_GI_RX         ( _AVEV3_GI_RXIINT | _AVEV3_GI_RXINT4 )

#define  _AVEV3_GT2_CNTEN      _BIT31
#define  _AVEV3_GT1_CNTEN      _BIT15

#define  _AVEV3_TXCR_LBK      _BIT29
#define  _AVEV3_TXWFLOWH      _BIT21
#define  _AVEV3_TXCR_FLOCTR   _BIT18

#define  _AVEV3_RXCR_RXEN     _BIT30
#define  _AVEV3_RXCR_FDUPEN   _BIT22
#define  _AVEV3_RXCR_FLOCTR   _BIT21
#define  _AVEV3_RXCR_FLUSHON  _BIT20
#define  _AVEV3_RXCR_AFEN     _BIT19
#define  _AVEV3_RXCR_DRPEN    _BIT18  

#define  _AVEV3_MDIOCTR_RREQ  _BIT3
#define  _AVEV3_MDIOCTR_WREQ  _BIT2

#define _AVEV3_MDIOSR_STS     _BIT0


#define _AVEV3_DESCC_TD      _BIT0
#define _AVEV3_DESCC_RDSTP   _BIT4
#define _AVEV3_DESCC_RD0     _BIT8
#define _AVEV3_DESCC_TDS     _BIT16  

#define _AVEV3_DESCC_CTRL_MASK     (0x0000FFFF)

#define  _AVEV3_TXDC_TXDSA_MASK    (0x000007FF)
#define  _AVEV3_TXDC_TXDSIZ_MASK   (0x0FFF0000)

#define  _AVEV3_TXDC_RXDSA_MASK    (0x00001FFF)
#define  _AVEV3_TXDC_RXDSIZ_MASK   (0x1FFF0000)

#define _AVEV3_IIRQC_EN      _BIT31


#define  _AVEV3_PFSEL_RING    (0x00)
#define  _AVEV3_PFSEL_WM      (0x80000000)

#define  _AVEV3_PFMBYTE0_MASK (0xFFCC003F)
#define  _AVEV3_PFMBYTE1_MASK (0x03FFFFFF)

#define _AVEV3_CLKCR_TXCLKEN _BIT2 

#define  _AVEV3_STS_OWN     _BIT31
#define  _AVEV3_STS_INTR    _BIT29
#define  _AVEV3_STS_OK      _BIT27
#define  _AVEV3_STS_DEST    (_BIT24|_BIT23)
#define  _AVEV3_STS_OWC     _BIT21 
#define  _AVEV3_STS_EC      _BIT20 
#define  _AVEV3_STS_CCNT    (_BIT19|_BIT18|_BIT17|_BIT16) 
#define  _AVEV3_STS_VLAN    _BIT16 

#define  _AVEV3_STS_PKTLEN  0x000007FF

#define AVEV3_CMDSTS_OFFSET    (0)
#define AVEV3_BUFPTR_OFFSET    (4)

void avev3_proc_add(char *trace_msg);
int  avev3_mdio_read(struct net_device *dev, int phy_id, int location);
void avev3_mdio_write (struct net_device *dev, int phy_id, int location, unsigned long val);

struct avev3_private {
  spinlock_t            lock;       
  int               macaddr_got;
  struct net_device_stats   stats;
  char              id_str[8];
  union {
    unsigned long hex;
    char str[4];
  } avev3_vr;
  long          in_interrupt;   
  int           phy_id;     
  unsigned short    partner;    
  struct mii_if_info    mii_if;     
  u32           msg_enable; 
  unsigned short    flags;      
  unsigned long     offset;     
  int           iintcnt;        

  unsigned long     tx_dnum;    
  unsigned long     tx_proc_idx, tx_done_idx;
  struct sk_buff    *tx_skbs[_AVEV3_TXDMAX];
  char                  dummy[16]; 
  unsigned char     tx_short[_AVEV3_TXDMAX][96];

  unsigned long     rx_dnum[_AVEV3_RXRING_NUM];
  unsigned long     rx_proc_idx[_AVEV3_RXRING_NUM], rx_done_idx[_AVEV3_RXRING_NUM];
  unsigned long     rx_dsa[_AVEV3_RXRING_NUM]; 
  struct sk_buff    *rx_skbs[_AVEV3_RXRING_NUM][_AVEV3_RXDMAX];


  struct timer_list timer;  


};

struct avev3_descriptor_matrix {
  u32                   tx;
  u32                   rx[_AVEV3_RXRING_NUM];
};

struct AVEV3_proc_info{
  char tag[16];
  unsigned int value;
};

extern unsigned long avev3_reg_base;

static inline void __iomem *__avev3_io(unsigned long addr)
{
	switch (addr) {
	case 0 ... (_AVEV3_IO_SIZE - 1):
		return (void __iomem *)(addr + avev3_reg_base);
	default:
		BUG();
	}
}
#define avev3_reg_read(addr)		readl(__avev3_io(addr))
#define avev3_reg_write(value, addr)	writel((value), __avev3_io(addr))

#define AVEV3_DISABLE_INT() AVEV3_REG_WRITE(0, _AVEV3_GIMR)
#define AVEV3_ENABLE_MININT()   AVEV3_REG_WRITE((_AVEV3_GI_RX | \
                        _AVEV3_GI_RXDROP |  \
                        _AVEV3_GI_RXOVF |   \
                        _AVEV3_GI_TX |  \
                        _AVEV3_GI_PHY), _AVEV3_GIMR)

#endif  
